#include <HidroExtractByRasterMask.h>

#include <TeRaster.h>
#include <qmessagebox.h>

TeRaster* extractByRasterMask( TeRaster* maskRaster, TeRaster* inputRaster )
{ 
  // inputRaster params
  TeRasterParams inputRasterParams = inputRaster->params();  
  
  // maskRaster params
  TeRasterParams maskRasterParams = maskRaster->params();  

  // outputRaster params
  TeRasterParams outParams = inputRasterParams;
  
  // change the bouding box 
  outParams.boundingBoxLinesColumns( maskRasterParams.boundingBox().x1_,
    maskRasterParams.boundingBox().y1_,
    maskRasterParams.boundingBox().x2_,
    maskRasterParams.boundingBox().y2_,
    maskRasterParams.nlines_, maskRasterParams.ncols_ );
  
  // Set dummy
  double dummy;
  if( inputRasterParams.useDummy_ )
  {
    dummy = inputRasterParams.dummy_[0];
  }
  else
  {
     // srtms
    outParams.setDummy( -9999 );
    outParams.useDummy_ = true;
    dummy = -9999;
  }

  //change mode
  outParams.mode_ = 'w';
  outParams.decoderIdentifier_ = "SMARTMEM";
  
  // Set Max and Minimal values
  outParams.vmax_[0] = -TeMAXFLOAT;
  outParams.vmin_[0] =  TeMAXFLOAT;

  TeRaster* outputRaster = new TeRaster( outParams );
  
  // verify if outputRaster raster created is valid
  if( !outputRaster->init() )
  {
    QMessageBox::warning(0, "Warning", "Error create TeRaster.");    
	  return 0;
  }  

  // pega x0 e y0 correspondete da mascara
  TeBox maskRasterBox = maskRasterParams.box();
  TeCoord2D maskRasterCoord( maskRasterBox.x1_, maskRasterBox.y2_ );

  TeCoord2D inputRasterCoord = inputRaster->coord2Index( maskRasterCoord );

  unsigned int x0 = TeRound(inputRasterCoord.x_);
  unsigned int y0 = TeRound(inputRasterCoord.y_);

  // Copy Values
  double val;
  for( int line=0; line<maskRasterParams.nlines_; line++ )
  {
    for( int column=0; column<maskRasterParams.ncols_; column++ )
    {
      maskRaster->getElement( column, line, val );
      if( val != -9999 )
      {
        inputRaster->getElement( column+x0, line+y0, val );
      }
      else
      {
        val = dummy;
      }
      outputRaster->setElement( column, line, val );
    }
  }

  return outputRaster;
}