#ifndef HIDRO_FLOW_GRID_H
#define HIDRO_FLOW_GRID_H

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

#include<queue>
// forward declarations
class TeRaster;

class HidroFlowGrid
{
public:
  HidroFlowGrid( TeRaster* demRaster,
    TeRaster* &lddRaster,    
    TeRaster* &fixedDemRaster,
    bool cavePlaneAreas,
    bool singlePits,
    bool partialResult,
    bool removeOutliers,
    double lowOutlierThreshold,
    std::string partialResultName,
    std::string outputDirectory );

  bool execute();

  const std::string& getErrorMessage();
  const std::string& getTimeStart();
  const std::string& getTimeEnd();
  const std::string& getTimeTotal();

  TePDIMatrix<unsigned char> lddMatrix_;  

  std::string errorMessage_; //!< Inform about an error message.
  std::string timeStart_; //!< Start time of proccess.
  std::string timeEnd_; //!< End time of proccess.
  std::string timeTotal_; //!< Total time of proccess.

  bool d8( unsigned int line, unsigned int column );

  bool hasDummy_;
  double demDummy_;

  bool cancel();
  
  bool slopeCompute( unsigned int line, unsigned int column, double slopeNeighbors[8] );
  double altimetriaMeanCompute( unsigned int line, unsigned int column );
  double maxSlope( double slopeNeighbors[8], unsigned char& maxSlopeDirection );
  int ndirectionCompute( double altimetriaNeighbors[8], double vmin );
  double minSlope( double altimetriaNeighbors[8], unsigned char& minSlopeDirection );
  bool isBorder( unsigned int line, unsigned int column );

  bool saveTiff();

  TePDIMatrix<double> demMatrix_;

  unsigned char lddDirectionsMap_[8];  

  TeRaster* demRaster_;
  TeRaster* &lddRaster_;    
  TeRaster* &fixedDemRaster_;
  bool cavePlaneAreas_;
  bool singlePits_;
  bool partialResult_;
  std::string partialResultName_;
  std::string outputDirectory_;
  std::string partialResultFullName_;

  // low Outlier
  bool removeOutliers_;
  double lowOutlierThreshold_;

};

#endif //HIDRO_FLOW_GRID_H

