#ifndef _HIDRO_HAND_H_
#define _HIDRO_HAND_H_

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;

class HidroHand : public HidroFlowAlgorithm
{
public:
  HidroHand( 
    TeRaster* demRaster,
    TeRaster* lddRaster,
    TeRaster* drainageRaster,
    TeRaster* &handRaster );

  ~HidroHand();

  bool execute();

protected:
  bool cancel();

  TeRaster* demRaster_;
  TeRaster* lddRaster_;
  TeRaster* drainageRaster_;
  TeRaster* &handRaster_;

  TePDIMatrix<float> demMatrix_;  
  TePDIMatrix<unsigned char> drainageMatrix_;
  TePDIMatrix<float> handMatrix_;
};

#endif
