
/*!
	\brief This is the Hidro Flow Group.
	@defgroup hidroFlow The Group for Plugin Flow Classes.
*/

#ifndef HIDRO_MINI_BASINS_H
#define HIDRO_MINI_BASINS_H

/** 
  * \file HidroMiniBasins.h
  *
  *
  * \brief This file is a class to segmental the drainage matrix. 
  *
  * \author Alexandre Copertino Jardim <alexcj@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroFlow
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;

class HidroMiniBasins : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param lddMatrix	LDD matrix (input).
    * \param drainageMatrix	Segmented matrix (input).
    * \param segmentedMatrix Micro basin matrix (result).
	  **/
    HidroMiniBasins(       
      TeRaster* lddRaster,
      TeRaster* segmentedRaster,
      TeRaster* &miniBasinsRaster );

    ~HidroMiniBasins();      
  
  //@}

  /**
   * @name Behavioral Methods
	 * Methods related to hidro segmenter behavior.
	**/
	//@{

    /**
    * \brief Segmenter the drainage matrix.	
    * \return True if successful, false otherwise.
	  **/
    bool execute();

  //@}

protected:
  /**
   * @name Internal Methods
	 * Internal Methods related to hidro segmenter behavior.
	**/
	//@{
    bool cancel();

  //@}

  /**
   * @name Attributes
	 * Attributes related to hidro segmenter.
	**/
	//@{
    TeRaster* lddRaster_;
    TeRaster* segmentedRaster_;
    TeRaster* &miniBasinsRaster_;
    
    TePDIMatrix<int> segmentedMatrix_; //!< Segmentald matrix.
    TePDIMatrix<int> miniBasinsMatrix_; //!< Micro basin matrix matrix.    
  //@}
};

#endif //HIDRO_MINI_BASINS_H

