#include <HidroRiversL.h>
#include <HidroFlowUtils.h>

#include <TeRaster.h>
#include <TePDIMatrix.hpp>

#include <cstdlib>
#include <TePDIUtils.hpp>

HidroRiversLenght::HidroRiversLenght( TeRaster* lddRaster, TeRaster* drRaster,TeRaster* ctRaster, TeRaster* &RLRaster ,float LDDres,bool gen_prof, TePointSet exutorio,TeRaster* DEMRaster,TeRaster* SUBRaster,string outputName ):

    HidroFlowAlgorithm( lddRaster ),    
    lddRaster_(lddRaster), 
    drRaster_(drRaster),
	ctRaster_(ctRaster),
    RLRaster_(RLRaster),
	LDDres_(LDDres),
	generate_profile_(gen_prof),
	exutorio_(exutorio),
	DEMRaster_(DEMRaster),
	SUBRaster_(SUBRaster),
	outputName_(outputName)
{  
}

HidroRiversLenght::~HidroRiversLenght()  
{
		// Free Memory
	  lddMatrix_.clear();
	  RLMatrix_.clear();  
	  connectionsMx_.clear(); 
	  distMatrix_.clear(); 
	  zero_start.clear();
}

bool
HidroRiversLenght::execute()
{
		// guarda a hora inicial do processo
		Time::instance().start();
		timeStart_ = Time::instance().actualTimeString();

		// load LDD
		TeProgress::instance()->reset();
		TeProgress::instance()->setCaption("TerraHidro");
		TeProgress::instance()->setMessage("Load LDD data.");
		if( !copyRaster2PDIMatrix( lddRaster_, lddMatrix_, MATRIX_MAX_PERCENT_USAGE ) )
		{
			 return cancel();
		}


		// load Drainage

		TeProgress::instance()->reset();
		TeProgress::instance()->setCaption("TerraHidro");
		TeProgress::instance()->setMessage("Load Drainage data.");
		if( !copyRaster2PDIMatrix( drRaster_, drMatrix_, MATRIX_MAX_PERCENT_USAGE ) )
		{
			 return cancel();
		}
			
		//Resolution = drRaster_->params().resolution_;

		//Contributing area

		TeProgress::instance()->reset();
		TeProgress::instance()->setCaption("TerraHidro");
		TeProgress::instance()->setMessage("Load Contributing area data.");
		if( !copyRaster2PDIMatrix( ctRaster_, ctMatrix_, MATRIX_MAX_PERCENT_USAGE ) )
		{
			 return cancel();
		}
		
		//DEM GRID

		TeProgress::instance()->reset();
		TeProgress::instance()->setCaption("TerraHidro");
		TeProgress::instance()->setMessage("Load DEM GRID data.");
		if( !copyRaster2PDIMatrix( DEMRaster_, DEMMatrix_, MATRIX_MAX_PERCENT_USAGE ) )
		{
			 return cancel();
		}

		//WATERSHED

		TeProgress::instance()->reset();
		TeProgress::instance()->setCaption("TerraHidro");
		TeProgress::instance()->setMessage("Load watershed data.");
		if( !copyRaster2PDIMatrix( SUBRaster_, SUBMatrix_, MATRIX_MAX_PERCENT_USAGE ) )
		{
			 return cancel();
		}

		// Looking for Juzante point
		unsigned int nl = ctMatrix_.GetLines();
		unsigned int nc = ctMatrix_.GetColumns();

		TeProgress::instance()->setTotalSteps( nl * 2 );

		 // init connection matrix with zeros and dummys (255)  
		 connectionsMx_.Reset( nl, nc, TePDIMatrix<float>::AutoMemPol, connectionsMx_.getMaxTmpFileSize(), MATRIX_MAX_PERCENT_USAGE );

			// create output RL raster
  
		// RLRaster params
		TeRasterParams RLRasterParams = lddRaster_->params();
  
		// Set dummy
		RLRasterParams.setDummy( -9999 );
		RLRasterParams.useDummy_ = true;  

		// Change mode
		RLRasterParams.setDataType( TeFLOAT );
		RLRasterParams.mode_ = 'w';
		RLRasterParams.decoderIdentifier_ = "SMARTMEM";

		// Set Max and Minimal values
		RLRasterParams.vmax_[0] = -TeMAXFLOAT;
		RLRasterParams.vmin_[0] =  TeMAXFLOAT;

		// create the raster
		RLRaster_ = new TeRaster( RLRasterParams );

		// verify if RLRaster created is valid
		if( !RLRaster_->init() )
		{
			errorMessage_ =RLRaster_->errorMessage();    
			timeEnd_ = Time::instance().actualTimeString();
			timeTotal_ = Time::instance().partialString();
			return false;
		}  

		// used in for's and progress bar
		unsigned int nlines = RLRaster_->params().nlines_;
		unsigned int ncolumns = RLRaster_->params().ncols_;  

		// start the progress bar
		TeProgress::instance()->reset();
		TeProgress::instance()->setCaption("TerraHidro");	

		// STEP 1
		TeProgress::instance()->setMessage("Creating Rivers Lenght Raster step 1 from 6.");
		TeProgress::instance()->setTotalSteps( nlines );

		// init RL matrix
		if( !initRLMatrix() ) return false;

		// STEP 2

		// refresh progress bar
		TeProgress::instance()->setMessage("Initializing Conections Matrix step 2 from 6.");
		TeProgress::instance()->setProgress( 0 );
  
		// init connections matrix
		if( !initConnections() ) return false;

		long maior = -9999;

		//	STEP 3
		// refresh progress bar
		TeProgress::instance()->setMessage("Creating zero_start vector step 3 from 6.");
		TeProgress::instance()->setProgress( 0 );

		TePoint exu = exutorio_.first();
		jusante = RLRaster_->coord2Index(exu.elem());

		unsigned int nlines2 = drRaster_->params().nlines_;
		unsigned int ncolumns2 = drRaster_->params().ncols_;  

		// STEP 4
		// refresh progress bar
		TeProgress::instance()->setMessage("Creating conection matriz step 4 from 6.");
		TeProgress::instance()->setProgress( 0 );


		// Calculate the RL matrix
		unsigned int lineFrom;
		unsigned int columnFrom;
		unsigned int lineTo;
		unsigned int columnTo;
		short dist;

		for(unsigned int index = 0; index < zero_start.size(); index++) // Inicializa em todos os 0 da matriz de conexoes
		{
			columnFrom = zero_start[index].x();
			lineFrom = zero_start[index].y();
			// Verify if is jusante point
			if (jusante.x() == columnFrom && jusante.y() == lineFrom)
			{
				continue;
			}
			dist = 0;
			while( lddCode2LineColumn( lineFrom, columnFrom, lineTo, columnTo ) )
			{
				if( distMatrix_[lineTo][columnTo] == -9999 ) //pergunta se o rpxomo  dummy
				{
						dist = dist+1;
						distMatrix_[lineTo][columnTo] = dist;
						if(connectionsMx_[lineTo][columnTo] > 1) // pergunta se matrizx de conexao > 1
						{
							connectionsMx_[lineTo][columnTo]--; //decrementa a conexao
							break; // pega outro zero
						}
				}
				else // se nao  dummu
				{
					if( distMatrix_[lineTo][columnTo] < dist)
					{
						dist =dist+1;
						distMatrix_[lineTo][columnTo] = dist;
					}
					else
					{
						dist = distMatrix_[lineTo][columnTo];
					}
				}
	
				lineFrom = lineTo;
				columnFrom = columnTo;

			}
			// atualiza barra de progresso
			TeProgress::instance()->setProgress( index );

			// verifica se usurio cancelou a operao
			if( TeProgress::instance()->wasCancelled() )
			{
				return cancel();
			}

		}

		// STEP 5
		// refresh progress bar
		TeProgress::instance()->setMessage("Creating distance matrix step 5 from 6.");
		TeProgress::instance()->setProgress( 0 );
		
		bool diag_matrix[3][3]={true,false,true,false,false,false,true,false,true};

		// Cria imagem de saida com o maior rio - caminho cntrairo iniciando na jusante
		char* outname = new char[outputName_.length() +5];
		strcpy(outname,outputName_.c_str());
		strcat(outname,".txt");
		
		fptxt = fopen(outname,"w");
		fprintf (fptxt, "Coordenadas X,Y,Z \n");
		int lineini = jusante.y();
		int columnini= jusante.x();
		int distini = distMatrix_[lineini][columnini]-1;
		RLMatrix_[lineini][columnini] = 1;
		int val;
		RLenght_=0.;
		int contad=0;

		while (distini !=0)
		{
			contad++;
			bool prox = false;
			for (int i = -1; i<2; i++)
			{
				for (int j=-1; j<2; j++)
				{
					if(j==0 && i==0) continue;
					val = distMatrix_[lineini-i][columnini-j];
					if(val == distini)
					{
						if(diag_matrix[i+1][j+1])
						{
							RLenght_ = RLenght_ + 1.4142*LDDres_;
						}
						else 
						{
							RLenght_ = RLenght_ + LDDres_;
						}

						RLMatrix_[lineini][columnini] = 1;

						TeCoord2D indexxy( columnini, lineini );
						TeCoord2D coord = lddRaster_->index2Coord( indexxy );
						double z = DEMMatrix_[lineini][columnini] ;
						fprintf (fptxt, "%f %f %f\n",coord.x(),coord.y(),z);
						prox = true;
						lineini = lineini-i;
						columnini = columnini-j;
						distini --;
						break;
					}
				}
				if(prox) break;
			}

			
			// atualiza barra de progresso
			TeProgress::instance()->setProgress( contad );

			// verifica se usurio cancelou a operao
			if( TeProgress::instance()->wasCancelled() )
			{
				return cancel();
			}
		}
					
		// Free Memory  
		lddMatrix_.clear();
		RLenght_  = RLenght_ /1000.;
		fprintf (fptxt, "\n\ Comprimento do Rio (km): %f\n",RLenght_);
		fclose(fptxt);
		// STEP 6

		// copy matrix values to raster.
		TeProgress::instance()->setMessage("Creating RL Raster step 6 from 6.");
		if( !copyPDIMatrix2Raster( RLMatrix_, RLRaster_) )
		{
			return cancel();
		}

		  
		// Free Memory  
		RLMatrix_.clear();
		 
		// Finish progress bar
		TeProgress::instance()->reset();  
 
		// save processing time 
		timeEnd_ = Time::instance().actualTimeString();
		timeTotal_ = Time::instance().partialString();


	  return true;
}

bool HidroRiversLenght::cancel()
{
  // Free Memory  
  lddMatrix_.clear();
  RLMatrix_.clear();  
  connectionsMx_.clear(); 
  distMatrix_.clear(); 
  zero_start.clear();
  return HidroRiversLenght::cancel();
}

bool
HidroRiversLenght::initRLMatrix()
{
	  unsigned int nlines = RLRaster_->params().nlines_;
	  unsigned int ncolumns = RLRaster_->params().ncols_;

	  RLMatrix_.Reset( nlines, ncolumns, TePDIMatrix<float>::AutoMemPol,RLMatrix_.getMaxTmpFileSize(), MATRIX_MAX_PERCENT_USAGE );
	  for( unsigned int line=0; line<nlines; line++ )
	  {
			for( unsigned int column=0; column<ncolumns; column++ )
			{      
				RLMatrix_[line][column] = 0;
			}
			// atualiza barra de progresso
			TeProgress::instance()->setProgress( line );

			// verifica se usurio cancelou a operao
			if( TeProgress::instance()->wasCancelled() )
			{
				return cancel();
			}
	  }

	  return true;
}

bool
HidroRiversLenght::initConnections()
{
	  unsigned int nlines = lddMatrix_.GetLines();
	  unsigned int ncolumns = lddMatrix_.GetColumns();

	  TeProgress::instance()->setTotalSteps( nlines * 2 );

	  // init connection matrix with zeros and dummys (255)  
	  connectionsMx_.Reset( nlines, ncolumns, TePDIMatrix<float>::AutoMemPol, connectionsMx_.getMaxTmpFileSize(), MATRIX_MAX_PERCENT_USAGE );
	  for( unsigned int line=0; line<nlines; line++ )
	  {
			for( unsigned int column=0; column<ncolumns; column++ )
			{
				if (drMatrix_[line][column] == 1)
				{
					connectionsMx_[line][column] = 0;
				}
				else
				{
					connectionsMx_[line][column] = -999;
				}
			 }
 

			// refresh progress bar    
			TeProgress::instance()->setProgress( line );
    
			// check for cancel
			if( TeProgress::instance()->wasCancelled() )
			{
				return cancel();
			}
	  }

	  TeProgress::instance()->setTotalSteps( nlines * 2 );
  
	  // calculate connection matrix
	  unsigned int lineTo;
	  unsigned int columnTo;

	  for( unsigned int line=0; line<nlines; line++ )
	  {
			for( unsigned int column=0; column<ncolumns; column++ )
			{
				if(connectionsMx_[line][column] >=0)
				{
					if( lddCode2LineColumn( line, column, lineTo, columnTo ) )
					{  

						if( connectionsMx_[lineTo][columnTo]>=0 )
						{
							// If para o caso do ponto ser a jusante
							// verifica se  o ultimo ponto com 1 so vizinho
							int viz =0;
							for (int ii=-1; ii<2 ; ii++)
							{
								for(int jj =-1; jj< 2; jj++)
								{
									if(ii ==0 && jj==0) continue;
									if(connectionsMx_[lineTo + ii][columnTo + jj] >=0)
									{
										viz++;
									}
								}
							}
							if(viz > 1)
							{
								connectionsMx_[lineTo][columnTo]= connectionsMx_[lineTo][columnTo]+1.;
							}
						}
					}   
				}
			}
    		// refresh progress bar    
			TeProgress::instance()->setProgress(line );

			// check for cancel
			if( TeProgress::instance()->wasCancelled() )
			{
				return cancel();
			}
	  }

	// Init distance matrix with dummys and vector zero_start with all zeros of connectionsMx_
	  distMatrix_.Reset( nlines, ncolumns, TePDIMatrix<float>::AutoMemPol, distMatrix_.getMaxTmpFileSize(), MATRIX_MAX_PERCENT_USAGE );

	  for( unsigned int line=0; line<nlines; line++ )
	  {
			for( unsigned int column=0; column<ncolumns; column++ )
			{
				distMatrix_[line][column] = -9999;
				if(connectionsMx_[line][column] == 0 && SUBMatrix_[line][column] == 1) // Ponto esta dentro da Bacia
				{
					TeCoord2D pt(column,line);
					zero_start.push_back(pt);
				}

			}
			// refresh progress bar    
			TeProgress::instance()->setProgress(line );
    
			// check for cancel
			if( TeProgress::instance()->wasCancelled() )
			{
				return cancel();
			}
	  }
	  return true;
}
