#ifndef HIDRO_SLOPE_H
#define HIDRO_SLOPE_H

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;

class HidroSlope : public HidroFlowAlgorithm
{
public:
  HidroSlope( TeRaster* demRaster, TeRaster* &slopeRaster );

  ~HidroSlope();

  bool execute();

protected:

  bool cancel();

  bool metricSlope();

  bool latLongSlope();

  TeRaster* demRaster_;
  TeRaster* &slopeRaster_;

  TePDIMatrix<float> demMatrix_;
  TePDIMatrix<float> slopeMatrix_;

  float rasterDummy_;

};

#endif //HIDRO_SLOPE_H
