#ifndef HIDRO_CELL_HIG_H
#define HIDRO_CELL_HIG_H

#include <HidroTime.h>

#include <TePDIMatrix.hpp>

#include<queue>

class TeRaster;

#ifndef MATRIX_MAX_PERCENT_USAGE
  #define MATRIX_MAX_PERCENT_USAGE 5
#endif

class HidroCellHig : public HidroTime
{
public:
  HidroCellHig( 
    TeRaster* demRaster,
    TeRaster* blocksRaster,
    TeRaster* highSubwatershedRaster,
    TeRaster* lowLDDRaster,
    TeRaster* lowAccumulatedRaster,
    TeRaster* lowSubwatershedRaster,
    TeRaster* lengthRaster,
    TeRaster* slopeRaster,
    TeRaster* pathsRaster,
    std::string outFileName );

  ~HidroCellHig();

  bool execute();

protected:

  void blocks( unsigned int lineBegin, unsigned int lineEnd,
    unsigned int columnBegin, unsigned int columnEnd );

  float area( unsigned int line );

  void altimetria( unsigned int lineBegin, unsigned int lineEnd,
    unsigned int columnBegin, unsigned int columnEnd );

  // nome do arquivo de sada CELL.HIG
  std::string outFileName_;

  // ponteiro para arquivo de saida
  FILE *outFile_;

    // numero de linha ou coluna de pixels por celula do modelo
  int pixelsNumber_;
  int maxLines_;
  int maxColumns_;

  // Matrix
  /*TePDIMatrix<float> demMatrix_;
  /*TePDIMatrix<int> blocksMatrix_;
  TePDIMatrix<int> highSubwatershedMatrix_;  
  TePDIMatrix<unsigned char> lowLDDMatrix_;
  TePDIMatrix<float> lowAccumulatedMatrix_;
  TePDIMatrix<int> lowSubwatershedMatrix_;
  TePDIMatrix<float> lengthMatrix_;
  TePDIMatrix<float> slopeMatrix_;*/
  TePDIMatrix<unsigned int> cellMatrix_;

  // Rasters
  TeRaster* demRaster_;
  TeRaster* blocksRaster_;
  TeRaster* highSubwatershedRaster_;
  TeRaster* lowLDDRaster_;
  TeRaster* lowAccumulatedRaster_;
  TeRaster* lowSubwatershedRaster_;
  TeRaster* lengthRaster_;
  TeRaster* slopeRaster_;
  TeRaster* pathsRaster_;
  
  int factor_;
  //float demDummy_;
  double blocksDummy_;
  double subWatershedDummy_;
  
  int lineIncrement_[129];
  int columnIncrement_[129];  

  double A ;
  double F ;   
	
  double E2 ; //!QUADRADO DA EXCENTRICIDADE

  double resx ;
  double resy ;
};


#endif //HIDRO_CELL_HIG_H
