#ifndef HIDRO_TOPOGRAPHIC_INDEX_MD_INFINITE_H
#define HIDRO_TOPOGRAPHIC_INDEX_MD_INFINITE_H

#include <HidroTime.h>

#include <TePDIMatrix.hpp>

#include<queue>

class TeRaster;

#ifndef MATRIX_MAX_PERCENT_USAGE
  #define MATRIX_MAX_PERCENT_USAGE 5
#endif

class HillTop
{
public:
  HillTop();

  HillTop( unsigned int line, unsigned int column, float altimetria );

  // Sobrecarga do operador > (greater than) para utilizar a priority_queue
  bool operator>( const HillTop &rightSide ) const; 

  unsigned int line_;
  unsigned int column_;
  float altimetria_;
};



class HidroTopographicIndexMDInfinite : public HidroTime
{
public:
  HidroTopographicIndexMDInfinite( 
    TeRaster* demRaster,
    TeRaster* lddRaster,
    TeRaster* highSubwatershedRaster,
    TeRaster* lowSubwatershedRaster,
    TeRaster* lowAccumulatedRaster,
    std::string modelFileName,
    std::string outFileName,
    float factor,
    float cit,
    int nac );

  ~HidroTopographicIndexMDInfinite();

  bool execute();

protected:
  // le as celulas do modelo
  bool readCell();

   // calcula a area acumulada de cada celula
  void accumulated( unsigned int lineBegin, unsigned int lineEnd,
    unsigned int columnBegin, unsigned int columnEnd );

  // calcula o histograma
  void histogram();

  // Insere os vizinhos na pilha de topo de morro
  void includeNeighbors( unsigned int line, unsigned int column );

  // acha os topos de morros
  void findHillTop();

  // retorna verdadeiro se  topo de morro
  bool isHillTop( unsigned int line, unsigned int column );

  // fila de prioridade de topo de morro
  priority_queue< HillTop, deque<HillTop>, greater<HillTop> > hillTopQueue_;

  // acha as direes e as declividades
  void md_inf( unsigned int line, unsigned int column );

  vector<float> slopeVector_;
  vector<float> directionVector_;

  // nome do arquivo do Modelo CELL.HIG
  std::string modelFileName_;
  
  // nome do arquivo de sada PARTOP.HIG
  std::string outFileName_;

  // ponteiro para arquivo de saida
  FILE *outFile_;

  // parametro CIT e NAC
  float cit_;
  int nac_;
  int natb_;
  float minSlope_;

  // celulas do modelo
  struct cellModel
  {
    int id_;
    float lat_;
    float long_;
  };
  std::vector<cellModel> cellsVector_;

  // resoluo do modelo
  float modelResolution_;
  
  // Fator
  int factor_;

  // numero de linha ou coluna de pixels por celula do modelo
  int pixelsNumber_;
  int maxLines_;
  int maxColumns_;

  TePDIMatrix<float> demMatrix_;
  TePDIMatrix<unsigned char> lddMatrix_;

  TePDIMatrix<float> accumulatedMatrix_;
  TePDIMatrix<float> topographicIndexMatrix_;

  float demDummy_;
  float topographicDummy_;
  float gridAverageSlope_;
  int gridNSlope_;
  
  // Rasters
  TeRaster* demRaster_;
  TeRaster* lddRaster_;
  TeRaster* highSubwatershedRaster_;
  TeRaster* lowSubwatershedRaster_;
  TeRaster* lowAccumulatedRaster_;

  int lineIncrement_[8];
  int columnIncrement_[8];

  char lineLDDIncrement_[255];
  char columnLDDIncrement_[255];
};


#endif //HIDRO_TOPOGRAPHIC_INDEX_MD_INFINITE_H
