/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include <HidroBlocks.h>
#include <HidroUtils.h>
#include <HidroFlowUtils.h>
#include <HidroPersister.h>
#include <qsettings.h>
#include <qcombobox.h>
#include <qfiledialog.h>


void HidroBlocksWindow::runPushButton_clicked()
{
  // Check inputs

  // DEM
  if(demComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM layer not defined."));
		return;
	}

  // Soil
  if(soilsComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Solos layer not defined."));
		return;
	}
  
  // Vegetation
  if(vegetationComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Vegetation layer not defined."));
		return;
	}  

  // Cells File
  if(cellsFileLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Cells File not defined."));
		return;
  }

  // Output File
  if(outputFileLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Blocks File not defined."));
		return;
  }

  // open input raster's
  HidroUtils utils(parameters_->getCurrentDatabasePtr());
  std::string errorMessage = "";

  // Blocks Grid Name
	if(blocksGridLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Blocks Grid name not defined."));
		return;
	}
  if(!utils.checkLayerName(blocksGridLineEdit->text().latin1(), errorMessage))
	{
		QMessageBox::warning(this, tr("Warning"), errorMessage.c_str());
		return;
	}
  
  // DEM
  TeLayer* demLayer = NULL;
	demLayer = utils.getLayerByName( demComboBox->currentText().latin1() );
  TeRaster* demRaster = NULL;
  demRaster = demLayer->raster();

  // Solos
  TeLayer* soilsLayer = NULL;
	soilsLayer = utils.getLayerByName( soilsComboBox->currentText().latin1() );
  TeRaster* soilsRaster = NULL;
  soilsRaster = soilsLayer->raster();

  // Vegetation
  TeLayer* vegetationLayer = NULL;
	vegetationLayer = utils.getLayerByName( vegetationComboBox->currentText().latin1() );
  TeRaster* vegetationRaster = NULL;
  vegetationRaster = vegetationLayer->raster();
  
  // Parameters
  std::string cellFileName = cellsFileLineEdit->text().latin1();
  std::string outFileName = outputFileLineEdit->text().latin1();
  std::string groupsFileName = outputFileLineEdit->text().latin1();
  
  // output raster
  TeRaster* blocksGridRaster = NULL;

  // Topographic Index
  HidroBlocks blocksGenerator( demRaster,
    soilsRaster,
    vegetationRaster,
    cellFileName,
    blocksGridRaster,
    outFileName,
    groupsFileName );

  // execut the algorithm
  if( !blocksGenerator.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(blocksGenerator.getErrorMessage().c_str()));
    
    if( demRaster )
    {
      delete demRaster;
    }

    if( soilsRaster )
    {
      delete soilsRaster;
    }

    if( vegetationRaster )
    {
      delete vegetationRaster;
    }
  }

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
  settings.writeEntry( "lastDEM", demComboBox->currentText() );
  settings.writeEntry( "lastSoils", soilsComboBox->currentText() );  
  settings.writeEntry( "lastVegetation", vegetationComboBox->currentText() );  
  settings.writeEntry( "lastBlocksGrid", blocksGridLineEdit->text() );
  settings.writeEntry( "lastPARTOP", outputFileLineEdit->text() );
  settings.writeEntry( "lastCELLHIG", cellsFileLineEdit->text() );

  // lsdate the TerraView interface
  parameters_->updateTVInterface();

  // informe the successful process
  QString message;
  message.append("Blocks Generator\n");
  message.append("Start Time: ");
  message.append( blocksGenerator.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( blocksGenerator.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( blocksGenerator.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );

  // close the window
  accept(); 
}


void HidroBlocksWindow::cellsFileToolButton_clicked()
{
  QSettings settings;
  settings.setPath( "TerraHidro.br", "Blocks Generator", QSettings::User );

  QString path = settings.readEntry( "cellsFile" );  

  QString cellsFileName = QFileDialog::getOpenFileName(path, 
		"HIG Files(*.hig *.HIG);;TXT Files(*.txt *.TXT);;ALL Files(*.*)",
	  this, 0, tr( "Open Cells File"));
	
	if (!cellsFileName.isEmpty())
  {
		cellsFileLineEdit->setText(cellsFileName);
    QFileInfo cellsFile( cellsFileName );
    path = cellsFile.dirPath();
    settings.writeEntry( "cellsFile", path );
  }
}


void HidroBlocksWindow::outputFileToolButton_clicked()
{
  QSettings settings;
  settings.setPath( "TerraHidro.br", "Blocks Generator", QSettings::User );

  QString outPath = settings.readEntry( "outFile" );  

  QString outFileName = QFileDialog::getSaveFileName(outPath,
    "HIG Files(*.hig *.HIG);;TXT Files(*.txt *.TXT);;ALL Files(*.*)",this,"Save as","File name");
	
  if (!outFileName.isEmpty())	
  {
	  outputFileLineEdit->setText(outFileName);
    QFileInfo outFile( outFileName );
    outPath = outFile.dirPath();
    settings.writeEntry( "outFile", outPath );
  }
}


bool HidroBlocksWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  demComboBox->clear();
	demComboBox->insertItem("");

  soilsComboBox->clear();
	soilsComboBox->insertItem("");

	vegetationComboBox->clear();
	vegetationComboBox->insertItem("");  

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{
		demComboBox->insertItem(layerNames[i].c_str());
    soilsComboBox->insertItem(layerNames[i].c_str());
		vegetationComboBox->insertItem(layerNames[i].c_str());   
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastDEM = settings.readEntry("lastDEM");
  QString lastSoils = settings.readEntry("lastSoils");
  QString lastVegetation = settings.readEntry("lastVegetation");
  QString lastBlocksGrid = settings.readEntry("lastBlocksGrid");    
  QString lastCELLHIG = settings.readEntry("lastCELLHIG");

  int index;

  index = comboboxFind( demComboBox, lastDEM );
  demComboBox->setCurrentItem( index );

  index = comboboxFind( soilsComboBox, lastSoils );
  soilsComboBox->setCurrentItem( index );

  index = comboboxFind( vegetationComboBox, lastVegetation );
  vegetationComboBox->setCurrentItem( index );
  
  outputFileLineEdit->setText( lastBlocksGrid );  
  cellsFileLineEdit->setText( lastCELLHIG );  

  return true;
}
