/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroDrainageExtraction.h>

#include <HidroUtils.h>
#include <HidroFlowUtils.h>

#include <qsettings.h>
#include <qcombobox.h>

void HidroDrainageExtractionWindow::runPushButton_clicked()
{
  // check inputs

  // Get View
  TeView* view = 0;
  view = parameters_->getCurrentViewPtr();
  if( !view )
  {
    QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
    return;
  }
  
  // LDD
  if(flowGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input LDD layer not defined."));
		return;
	}
  // Contributing Area
  if(contributingAreaComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Contributing Area layer not defined."));
		return;
	}
  // VDNP
  if(vdnpComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input VDNP layer not defined."));
		return;
	}

  // Contributing Area Threshold
  if(contributingAreaThresholdLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Model Resolution not defined."));
		return;
  }

  // VDNP Threshold
  if(vdnpThresholdLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("CIT not defined."));
		return;
  }

  HidroUtils utils(parameters_->getCurrentDatabasePtr());
  std::string errorMessage = "";

  // Output name (base layer  name)
	if(drainageLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Hand layer name not defined."));
		return;
	}
  if(!utils.checkLayerName(drainageLineEdit->text().latin1(), errorMessage))
	{
		QMessageBox::warning(this, tr("Warning"), errorMessage.c_str());
		return;
	}	 

  // open input raster's
  // LDD
  TeLayer* lddLayer = NULL;
	lddLayer = utils.getLayerByName( flowGridComboBox->currentText().latin1() );
  TeRaster* lddRaster = NULL;
  lddRaster = lddLayer->raster();

  // Contributing Area
  TeLayer* contributingAreaLayer = NULL;
	contributingAreaLayer = utils.getLayerByName( contributingAreaComboBox->currentText().latin1() );
  TeRaster* contributingAreaRaster = NULL;
  contributingAreaRaster = contributingAreaLayer->raster();

  // VDNP
  TeLayer* vdnpLayer = NULL;
	vdnpLayer = utils.getLayerByName( vdnpComboBox->currentText().latin1() );
  TeRaster* vdnpRaster = NULL;
  vdnpRaster = vdnpLayer->raster();

  // Parameters
  float contributingAreaThreshold = contributingAreaThresholdLineEdit->text().toFloat();
  float vdnpThreshold = vdnpThresholdLineEdit->text().toFloat();  

  // output raster
  TeRaster* drainageRaster = NULL;

  // Drainage Extraction
  HidroDrainageExtraction drainageExtraction( lddRaster,
    contributingAreaRaster,
    contributingAreaThreshold,
    drainageRaster,
    vdnpRaster,
    vdnpThreshold  );

  // execut the algorithm
  if( !drainageExtraction.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(drainageExtraction.getErrorMessage().c_str()));
    
    if( drainageRaster )
    {
      delete drainageRaster;
    }
    
    return;
  }

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
  settings.writeEntry( "lastLDD", flowGridComboBox->currentText() );
  settings.writeEntry( "lastACU", contributingAreaComboBox->currentText() );
  settings.writeEntry( "lastVDNP", vdnpComboBox->currentText() );
  settings.writeEntry( "lastACUthreshold", contributingAreaThresholdLineEdit->text() );
  settings.writeEntry( "lastVDNPThreshold", vdnpThresholdLineEdit->text() );
  settings.writeEntry( "lastDRE", drainageLineEdit->text() );
  
  // import result to database
  TeProgress::instance()->setMessage("Saving Drainage Raster into database.");
  utils.saveOutputRaster( drainageLineEdit->text().latin1(), drainageRaster );

  // create theme  
  TeLayer* drainageLayer = NULL;
	drainageLayer = utils.getLayerByName( drainageLineEdit->text().latin1() );
  if( view )
  {
    utils.rasterLegendOneColor( view, drainageLayer );
  }

  // update the TerraView interface
	parameters_->updateTVInterface();

  // close the window
  //accept(); 

  // informe the successful process
  QString message;
  message.append("Drainage\n");
  message.append("Start Time: ");
  message.append( drainageExtraction.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( drainageExtraction.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( drainageExtraction.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );
}


void HidroDrainageExtractionWindow::contributingAreaComboBox_activated( const QString & )
{
  if(contributingAreaComboBox->currentText().isEmpty())
	{		
		return;
	}

  TeLayer* inputLayer = NULL;

	HidroUtils utils(parameters_->getCurrentDatabasePtr());

	inputLayer = utils.getLayerByName(contributingAreaComboBox->currentText().latin1());

	if(!inputLayer)
	{
		//QMessageBox::warning(this, tr("Warning"), tr("Error getting layer from database."));
		return;
	}  
  
  if( !inputLayer->hasGeometry( TeRASTER ) )
  {
    //QMessageBox::warning(this, tr("Warning"), tr("inputLayer nao tem teraster."));
    return;
  }

  int threshold = (int)(inputLayer->raster()->params().vmax_[0] * 0.01);
  contributingAreaThresholdLineEdit->setText( QString::number( threshold ) );
}


bool HidroDrainageExtractionWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  flowGridComboBox->clear();
  flowGridComboBox->insertItem("");

  contributingAreaComboBox->clear();
	contributingAreaComboBox->insertItem("");

  vdnpComboBox->clear();
	vdnpComboBox->insertItem("");

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{		
    flowGridComboBox->insertItem(layerNames[i].c_str());
    contributingAreaComboBox->insertItem(layerNames[i].c_str());
    vdnpComboBox->insertItem(layerNames[i].c_str());
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastLDD = settings.readEntry("lastLDD");
  QString lastACU = settings.readEntry("lastACU");
  QString lastVDNP = settings.readEntry("lastVDNP");
   
  int index;  

  index = comboboxFind( flowGridComboBox, lastLDD );
  flowGridComboBox->setCurrentItem( index );

  index = comboboxFind( contributingAreaComboBox, lastACU );
  contributingAreaComboBox->setCurrentItem( index );
  contributingAreaComboBox_activated( contributingAreaComboBox->currentText() );

  index = comboboxFind( vdnpComboBox, lastVDNP );
  vdnpComboBox->setCurrentItem( index );

  return true;
}
