
/*!
	\brief This is the Hidro Flow Group.
	@defgroup hidroFlow The Group for Plugin Flow Classes.
*/

#ifndef HIDRO_SEGMENTER_2_VECTOR_H
#define HIDRO_SEGMENTER_2_VECTOR_H

/** 
  * \file Segmenter2Vector2Vector2Vector.h
  *
  *
  * \brief This file is a class transform the segments raster in a vector.
  *
  * \author Alexandre Copertino Jardim <alexcj@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroFlow
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/

#include <HidroMatrix.hpp>


class Segmenter2Vector
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param lddMatrix	LDD matrix (input).    
    * \param segmentedMatrix Segmented matrix (input).
	  **/
  Segmenter2Vector( std::string& outputName, TeDatabase* database, TeRaster* segmentedRaster, HidroMatrix<unsigned char>& lddMatrix,
      HidroMatrix<int>& segmentedMatrix);
  
  //@}

  /**
   * @name Behavioral Methods
	 * Methods related to hidro segmenter behavior.
	**/
	//@{

    /**
    * \brief Vectorizing the segmented matrix.	
    * \return True if successful, false otherwise.
	  **/
    bool vectorizing();

    /**
    * \brief Save the operation statistics in a txt file.
	  * \param fileName Statistics txt file name.
	  **/
    void print( std::string fileName );  

    /**
    * \brief Return the error message.
    * \return Error message.
	  **/
    const std::string& getErrorMessage();

  //@}

protected:
  /**
   * @name Internal Methods
	 * Internal Methods related to hidro segmenter behavior.
	**/
	//@{

    /**
     * \brief Calculate the line and column of a drainage matrix pixel points to.
     * \param lineFrom Line of drainage matrix pixel.
     * \param columnFrom Column of drainage matrix pixel.
     * \param lineTo Line of pointed drainage matrix pixel.
     * \param columnTo Column of pointed drainage matrix pixel.
     * \return True if pointed pixel is valid (not dummy or out of drainage matrix range), false otherwise.
	  **/
    bool lddCode2LineColumn( const unsigned int &lineFrom, const unsigned int &columnFrom,
      unsigned int &lineTo, unsigned int &columnTo );

  //@}

  /**
   * @name Attributes
	 * Attributes related to hidro segmenter.
	**/
	//@{
    std::string& outputName_;
    TeDatabase* database_;
    TeRaster* segmentedRaster_;
    HidroMatrix<unsigned char>& lddMatrix_; //!< LDD matrix matrix.
    HidroMatrix<int>& segmentedMatrix_; //!< Segmentald matrix.

    unsigned int nlines_; //!< Number of matrixes lines.
    unsigned int ncolumns_; //!< Number of matrixes columns.

    std::string errorMessage_; //!< Inform about an error message in segmental proccess.

    std::string timeStart_; //!< Start time of proccess.
    std::string timeEnd_; //!< End time of proccess.
    std::string timeTotal_; //!< Total time of proccess.
  //@}
};

#endif //HIDRO_SEGMENTER_2_VECTOR_H

