#ifndef _HIDRO_MORPHOMETRIC_VARIABLES_H_
#define _HIDRO_MORPHOMETRIC_VARIABLES_H_

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;

class HidroMorphometricVariables : public HidroFlowAlgorithm
{
public:
  HidroMorphometricVariables( TeRaster* demRaster, TeRaster* *rasterpoint, bool* flagVariables );

  ~HidroMorphometricVariables();

  bool execute();

protected:

  bool cancel();

  TeRaster* demRaster_;
  TeRaster* *rasterpoint_;
  bool* flagVariables_;

  TePDIMatrix<float> demMatrix_;
  TePDIMatrix<float> pMatrix_;
  TePDIMatrix<float> qMatrix_;
  TePDIMatrix<float> rMatrix_;
  TePDIMatrix<float> sMatrix_;
  TePDIMatrix<float> tMatrix_;
  TePDIMatrix<float> varMatrix_;
  TePDIMatrix<float> meancurvMatrix_;
  TePDIMatrix<float> unspherMatrix_;
  TePDIMatrix<float> horcurvMatrix_;
  TePDIMatrix<float> diffcurvMatrix_;

};

#endif //_HIDRO_MORPHOMETRIC_VARIABLES_H_