#include <HidroTestProgress.h>

#include <iostream>

using std::string;
using std::cout;

HidroTestProgress::HidroTestProgress() :
	totalSteps_(0),
	curProg_(0)
{
}


HidroTestProgress::~HidroTestProgress()
{
}


void HidroTestProgress::setTotalSteps(int n)
{ 
  totalSteps_ = n; 
  curProg_=0;
}


void HidroTestProgress::reset()
{ 
	totalSteps_ = 0; 
	messageStr_ = "";
	captionStr_ = "";
	curProg_ = 0;
}


void HidroTestProgress::cancel()
{ 
	totalSteps_ = 0; 
	messageStr_ = "";
	captionStr_ = "";
	curProg_ = 0;
}


void HidroTestProgress::setMessage(const string& text)
{ 
  messageStr_ = text;
}


string HidroTestProgress::getMessage() 
{ 
  return messageStr_; 
}


bool HidroTestProgress::wasCancelled()
{ 
  return false; 
}
	

void HidroTestProgress::setCaption(const string& cap)
{ 
  captionStr_ = cap;
}


void HidroTestProgress::setProgress(int steps)
{
	int prog = (int)(100*steps/(totalSteps_+1));
	if (prog != curProg_)
	{
		cout << messageStr_ << " : " << prog << "%...\n";
		curProg_ = prog;
	}
}