#ifndef HIDRO_TEST_PROGRESS_H
#define HIDRO_TEST_PROGRESS_H

#include "TeProgressBase.h"
//#include <iostream>

//using std::string;
//using std::cout;

class HidroTestProgress : public TeProgressBase
{
	int totalSteps_;
	int curProg_;
	string messageStr_;
	string captionStr_;

public:
	HidroTestProgress();

	~HidroTestProgress();

	//! Sets the total number of steps to n 
	void setTotalSteps(int n);

	//! Resets the progress interface
	void reset();

	//! Cancel activity being excuted
	void cancel();

	//! Sets the label's text
	void setMessage(const string& text);

	//! Returns the label's text
	string getMessage() ;

	//! Returns true whether the process was cancelled
	bool wasCancelled();
	
	//! Sets the caption associated to the progress interface
	void setCaption(const string& cap);

	//! Display progress message
	void setProgress(int steps);
};
#endif //HIDRO_TEST_PROGRESS_H
