#include <HidroTestUtils.h>

#include <TeDatabase.h>

HidroTestUtils::HidroTestUtils(TeDatabase* database) : database_(database)
{
}

HidroTestUtils::~HidroTestUtils()
{
}


TeLayer* HidroTestUtils::getLayerByName( const std::string& layerName )
{
  database_->loadLayerSet();
  
  TeLayerMap::iterator it = database_->layerMap().begin();

  while( it != database_->layerMap().end() )
  {
    if( it->second->name() == layerName )
    {
      return it->second;
    }
    ++it;
  }

  return NULL;
}