/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

// TerraLib Includes
#include <PluginParameters.h>
#include <TeAppTheme.h>
#include <TeQtCanvas.h>
#include <TeUtils.h>

// Hidro Includes
#include <HidroUtils.h>
#include <HidroPersister.h>
#include <HidroMainWindow.h>

// Qt Includes
#include <qmessagebox.h>
#include <qsettings.h>
#include <qtabwidget.h>

void HidroBatchPointsWindow::init2( PluginParameters* parameters, bool hidroMain )
{
   _hidroMain = hidroMain;
   init( parameters );
}

// Constructor
bool HidroBatchPointsWindow::init( PluginParameters* parameters)
{
  if( parameters == NULL )
  {
    return false;
  }

  _layer = NULL;  

  _mainWindow = NULL;  

  _parameters = parameters;

  listLayers();

  stopPushButton->setEnabled( false );

  return true;
}

// Destructor
void HidroBatchPointsWindow::destroy()
{
  if( _mainWindow )
  {
    delete _mainWindow;
    _mainWindow = NULL;
  }
}

// newBatchPointRadioButton On
void HidroBatchPointsWindow::newBatchPointRadioButton_stateChanged( int state )
{
  if( state == QButton::On )
  {
    batchPointGroupLineEdit->setEnabled( true );
    batchPointGroupComboBox->setEnabled( false );
  }
}

// existentBatchPointRadioButton On
void HidroBatchPointsWindow::existentBatchPointRadioButton_stateChanged( int state )
{
  if( state == QButton::On )
  {
    batchPointGroupLineEdit->setEnabled( false );
    batchPointGroupComboBox->setEnabled( true );
  }
}

// list layers
void HidroBatchPointsWindow::listLayers()
{
  if( !_parameters->getCurrentDatabasePtr() )
	{
		return;
	}

  //clear all layers names inside the combo box
  batchPointGroupComboBox->clear();
	batchPointGroupComboBox->insertItem( "" );	

	HidroUtils utils( _parameters->getCurrentDatabasePtr() );

	std::vector<std::string> layerNames = utils.listLayers( false, true );

	for( unsigned int i = 0; i < layerNames.size(); ++i )
	{
		batchPointGroupComboBox->insertItem(layerNames[i].c_str());		
	}
}

// Star to get the points
void HidroBatchPointsWindow::startPushButton_clicked()
{
  // Check user information
  if( batchPointGroupLineEdit->text().isEmpty() )
  {
    QMessageBox::information(this, tr("Information"), tr("Set the batch point set name."));
    return;
  }
  TeView* view = 0;
  view = _parameters->getCurrentViewPtr();
  if( !view )
  {
    QMessageBox::information(this, tr("Information"), tr("Please select the output view in TerraView interface."));
    return;
  }

  // Disable set poiny name line edit
  batchPointGroupLineEdit->setDisabled( true );

  // get database
  if( !_parameters->getCurrentDatabasePtr() )
	{
		return;
	}
  TeDatabase* db = _parameters->getCurrentDatabasePtr();

  // Fora o usurio a selecionar um thema
  // Para o TerraView no cair
  if( !_parameters->getCurrentThemeAppPtr() )
  {
    QMessageBox::warning(
        this,
        tr("Warning"),
        tr("Select the Drainage Theme on TerraView!") );
    return;
  }

  // get current theme
  TeTheme* theme = (TeTheme*)_parameters->getCurrentThemeAppPtr()->getTheme();  

  // Create Layer
  if( newBatchPointRadioButton->isOn() )
  {
    // get layer name
    string layerName = batchPointGroupLineEdit->text().latin1();  	
    if( db->layerExist( layerName ) )
	  {
      QMessageBox::warning(
        this,
        tr("Warning"),
        tr("There is already a layer with the same name in the TerraLib database!") );
		  
		  return;
	  }

    // get theme projection
    TeProjection* projection = theme->getThemeProjection();

    // Create Layer
    _layer = new TeLayer( layerName, db, projection );
  }

  startPushButton->setEnabled( false );
  stopPushButton->setEnabled( true );

  // get the clicks
  connect(
    _parameters->teqtcanvas_ptr_,
    SIGNAL( mousePressed( TeCoord2D&, int, QPoint& ) ),
    this,
    SLOT( getMouseClicked( TeCoord2D&, int, QPoint& ) ) );
}

void HidroBatchPointsWindow::getMouseClicked( TeCoord2D & coord, int, QPoint & )
{
  if( _parameters->teqtcanvas_ptr_->getCursorMode() == _parameters->teqtcanvas_ptr_->Pointer ||
    _parameters->teqtcanvas_ptr_->getCursorMode() == _parameters->teqtcanvas_ptr_->Information )
  {
    TeCoord2D coordFixed;

    // get current theme
    TeTheme* theme = (TeTheme*)_parameters->getCurrentThemeAppPtr()->getTheme();

    // try to center in pixels raster
    if( theme->layer()->hasGeometry(TeRASTER) )
    {
      // get current raster
      TeRaster* raster = theme->layer()->raster();
      TeCoord2D rasterCoord = raster->coord2Index( coord );
      rasterCoord.setXY( TeRound(rasterCoord.x_), TeRound(rasterCoord.y_) );
      coordFixed = raster->index2Coord( rasterCoord );
    }
    else
    {
      coordFixed = coord;
    }
    
    // Create a point
    TePoint point( coordFixed );  
    _pointSet.add( point );

    // Informe
    QMessageBox::information(this, tr("Information"), tr("Batch Point created."));
  }
}

void HidroBatchPointsWindow::okPushButton_clicked()
{
  accept();
  if( _hidroMain )
  {
    if( _mainWindow )
    {
      delete _mainWindow;
    }
    _mainWindow = new HidroMainWindow((QWidget*)_parameters->qtmain_widget_ptr_, "Main Window", false);
	  _mainWindow->init(_parameters);
	  _mainWindow->show();
    _mainWindow->tabWidget->setCurrentPage(3);
  }
  else
  {
    ((QDialog*)this->parent())->show();
  }
}

void HidroBatchPointsWindow::stopPushButton_clicked()
{
  if( !_pointSet.empty() )
  {
    TeDatabase* db = _parameters->getCurrentDatabasePtr();    

    // Create an attribute table

	  // Define a list of attributes
	  TeAttributeList attList;

    // ID
	  TeAttribute at;
	  at.rep_.type_ = TeSTRING;
	  at.rep_.numChar_ = 16;
	  at.rep_.name_ = "object_id";
	  at.rep_.isPrimaryKey_ = true;
	  attList.push_back(at);

    // Name
    at.rep_.type_ = TeSTRING;
	  at.rep_.numChar_ = 255;
	  at.rep_.name_ = "name";
	  at.rep_.isPrimaryKey_ = false;
	  attList.push_back(at);

    // Creates a table in memory
    string attTableName = batchPointGroupLineEdit->text().latin1();
    attTableName.append("attTable");
    TeTable attTable( attTableName, attList, "object_id", "object_id" );    
	  
    if( !_layer->createAttributeTable( attTable ) )
    {
      QMessageBox::warning(
        this,
        tr("Warning"),
        tr(db->errorMessage().c_str()) );
      return;
    }

    // Each row is related to one of the geometries by its objetc_id
    for( unsigned int i=0; i < _pointSet.size(); ++i )
    {
      TeTableRow row;    
      _pointSet[i].objectId( Te2String(i) );
      row.push_back( _pointSet[i].objectId() );
	    row.push_back( "Batch Point " + _pointSet[i].objectId() );
      attTable.add(row);
    }

    _layer->addPoints( _pointSet );

    if( !_layer->saveAttributeTable( attTable ) )
    {
      QMessageBox::warning(
        this,
        tr("Warning"),
        tr(db->errorMessage().c_str()) );      
      return;
    }
  }

  disconnect(
    _parameters->teqtcanvas_ptr_,
    SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)),
    this,
    SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)) );

  // create theme
  HidroPersister persister( _parameters->getCurrentDatabasePtr() );
  persister.createTheme( batchPointGroupLineEdit->text().latin1(), "", _parameters->getCurrentViewPtr(), _layer );

  _parameters->updateTVInterface();

  startPushButton->setEnabled( true );
  stopPushButton->setEnabled( false );  
  batchPointGroupLineEdit->setDisabled( false );

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );
  settings.writeEntry( "lastPoints", batchPointGroupLineEdit->text() );
}