/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


#include <HidroConsistentDEMWindow.h>

#include <HidroConsistentDEM.h>

#include <HidroUtils.h>
#include <HidroFlowUtils.h>

#include <qsettings.h>
#include <qcombobox.h>

void HidroConsistentDEMWindow::runPushButton_clicked()
{
  // check inputs

  // Get View
  TeView* view = 0;
  view = parameters_->getCurrentViewPtr();
  if( !view )
  {
    QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
    return;
  }
  
  // LDD
  if(flowGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input LDD layer not defined."));
		return;
	}  
  // DEM
  if(demGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM layer not defined."));
		return;
	}


  HidroUtils utils(parameters_->getCurrentDatabasePtr());
  std::string errorMessage = "";

  // Output name (base layer  name)
	if(consistentDEMLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output DEM name not defined."));
		return;
	}
  if(!utils.checkLayerName(consistentDEMLineEdit->text().latin1(), errorMessage))
	{
		QMessageBox::warning(this, tr("Warning"), errorMessage.c_str());
		return;
	}	 

  // open input raster's
  // LDD
  TeLayer* lddLayer = NULL;
	lddLayer = utils.getLayerByName( flowGridComboBox->currentText().latin1() );
  TeRaster* lddRaster = NULL;
  lddRaster = lddLayer->raster();  

  // DEM
  TeLayer* demLayer = NULL;
	demLayer = utils.getLayerByName( demGridComboBox->currentText().latin1() );
  TeRaster* demRaster = NULL;
  demRaster = demLayer->raster();

  // output raster
  TeRaster* outputDEMRaster = NULL;

  // Drainage Extraction
  HidroConsistentDEM consistentDEM( lddRaster,
    demRaster,    
    outputDEMRaster);

  // execut the algorithm
  if( !consistentDEM.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(consistentDEM.getErrorMessage().c_str()));
    
    if( outputDEMRaster )
    {
      delete outputDEMRaster;
    }
    
    return;
  }

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
  settings.writeEntry( "lastLDD", flowGridComboBox->currentText() );
  settings.writeEntry( "lastDEM", demGridComboBox->currentText() );
   
  // import result to database
  TeProgress::instance()->setMessage("Saving DEM Raster into database.");
  utils.saveOutputRaster( consistentDEMLineEdit->text().latin1(), outputDEMRaster );

  // create theme  
  TeLayer* outputDEMLayer = NULL;
	outputDEMLayer = utils.getLayerByName( consistentDEMLineEdit->text().latin1() );
  if( view )
  {
    utils.rasterTheme( view, outputDEMLayer );
  }

  // update the TerraView interface
	parameters_->updateTVInterface();

  // close the window
  //accept(); 

  // informe the successful process
  QString message;
  message.append("Consistent DEM\n");
  message.append("Start Time: ");
  message.append( consistentDEM.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( consistentDEM.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( consistentDEM.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );

}


bool HidroConsistentDEMWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  flowGridComboBox->clear();
  flowGridComboBox->insertItem("");

  demGridComboBox->clear();
	demGridComboBox->insertItem("");  

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{		
    flowGridComboBox->insertItem(layerNames[i].c_str());
    demGridComboBox->insertItem(layerNames[i].c_str());
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastLDD = settings.readEntry("lastLDD"); 
  QString lastDEM = settings.readEntry("lastDEM");  
   
  int index;  

  index = comboboxFind( flowGridComboBox, lastLDD );
  flowGridComboBox->setCurrentItem( index );

  index = comboboxFind( demGridComboBox, lastDEM );
  demGridComboBox->setCurrentItem( index );

  return true;
}
