/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroVDNP.h>

#include <HidroUtils.h>
#include <HidroFlowUtils.h>

#include <qsettings.h>
#include <qcombobox.h>

void HidroFlowDependentVariablesWindow::runPushButton_clicked()
{
  // check inputs

  // Get View
  TeView* view = 0;
  view = parameters_->getCurrentViewPtr();
  if( !view )
  {
    QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
    return;
  }
  
  // DEM
  if(demGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM layer not defined."));
		return;
	}
  // LDD
  if(flowGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input LDD layer not defined."));
		return;
	}  

  // Output name (base layer  name)
	if(gridNameLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Hand layer name not defined."));
		return;
	}
	/*if(!checkLayerName(gridNameLineEdit->text().latin1()))
	{
    QMessageBox::warning(this, tr("Warning"), tr("Hand layer name already exist in this database."));
		return;
	}*/

  // open input raster's
  HidroUtils utils(parameters_->getCurrentDatabasePtr());

  // DEM
  TeLayer* demLayer = NULL;
	demLayer = utils.getLayerByName( demGridComboBox->currentText().latin1() );
  TeRaster* demRaster = NULL;
  demRaster = demLayer->raster();

  // LDD
  TeLayer* lddLayer = NULL;
	lddLayer = utils.getLayerByName( flowGridComboBox->currentText().latin1() );
  TeRaster* lddRaster = NULL;
  lddRaster = lddLayer->raster();
  
    
  if( vdnpCheckBox->isChecked() )
  {
    // output raster
    TeRaster* htbRaster = NULL;

    // Hand
    HidroVDNP hidroVDNP( demRaster, lddRaster, htbRaster );

    // execut the algorithm
    if( !hidroVDNP.execute() )
    {
      QMessageBox::warning(this, tr("Warning"), tr(hidroVDNP.getErrorMessage().c_str()));
    
      if( htbRaster )
      {
        delete htbRaster;
      }
    
      return;
    }
  
    // import result to database
    TeProgress::instance()->setMessage("Saving HTB Raster into database.");
    utils.saveOutputRaster( gridNameLineEdit->text().latin1(), htbRaster );

    // create theme  
    TeLayer* flowDependentVariablesLayer = NULL;
	  flowDependentVariablesLayer = utils.getLayerByName( gridNameLineEdit->text().latin1() );
    if( view )
    {
      utils.rasterTheme( view, flowDependentVariablesLayer );
    }

    // list all layers from current database
	  //listLayers();

    // update the TerraView interface
	  parameters_->updateTVInterface();

    // close the window
    //accept(); 

    // informe the successful process
    QString message;
    message.append("HTB\n");
    message.append("Start Time: ");
    message.append( hidroVDNP.getTimeStart().c_str() );
    message.append("\nEnd Time: ");
    message.append( hidroVDNP.getTimeEnd().c_str() );
    message.append("\n\nTotal Time: ");
    message.append( hidroVDNP.getTimeTotal().c_str() );

	  QMessageBox::information(this, tr("Information"), tr(message) );
  }
}


bool HidroFlowDependentVariablesWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  demGridComboBox->clear();
	demGridComboBox->insertItem("");

  flowGridComboBox->clear();
  flowGridComboBox->insertItem("");


  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{
		demGridComboBox->insertItem(layerNames[i].c_str());
    flowGridComboBox->insertItem(layerNames[i].c_str());
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastDEM = settings.readEntry("lastDEM");
  QString lastLDD = settings.readEntry("lastLDD");
   
  int index;

  index = comboboxFind( demGridComboBox, lastDEM );
  demGridComboBox->setCurrentItem( index );

  index = comboboxFind( flowGridComboBox, lastLDD );
  flowGridComboBox->setCurrentItem( index );

  return true;
}
