/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

//#include <HidroMorphometricVariablesWindow.h>
#include <HidroMorphometricVariables.h>
#include <HidroUtils.h>
#include <HidroFlowUtils.h>
#include <TeDatabase.h>

#include <qstring.h>
#include <qfiledialog.h>
#include <qsettings.h>
#include <qmessagebox.h>
#include <qcombobox.h>

#include <string>


void HidroMorphometricVariablesWindow::runPushButton_clicked()
{

  // Check inputs
  // DEM
  if(demGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM Grid not defined."));
		return;
	}

  // Output File
  if(gridNameLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output File not defined."));
		return;
  }

  // Selected Variables
  bool flagVariables[18];
  flagVariables[0] = slopeCheckBox->isChecked();
  flagVariables[1] = gradientFactorCheckBox->isChecked();
  flagVariables[2] = horizontalCurvatureCheckBox->isChecked();
  flagVariables[3] = planCurvatureCheckBox->isChecked();
  flagVariables[4] = verticalCurvatureCheckBox->isChecked();
  flagVariables[5] = meanCurvatureCheckBox->isChecked();
  flagVariables[6] = longitudinalCurvatureCheckBox->isChecked();
  flagVariables[7] = crossSectionalCurvatureCheckBox->isChecked();
  flagVariables[8] = unsphericityCheckBox->isChecked();
  flagVariables[9] = minimalCurvatureCheckBox->isChecked();
  flagVariables[10] = maximalCurvatureCheckBox->isChecked();
  flagVariables[11] = differenceCurvatureCheckBox->isChecked();
  flagVariables[12] = horizontalExcessCurvatureCheckBox->isChecked();
  flagVariables[13] = verticalExcessCurvatureCheckBox->isChecked();
  flagVariables[14] = rotorCheckBox->isChecked();
  flagVariables[15] = totalGaussianCurvatureCheckBox->isChecked();
  flagVariables[16] = totalRingCurvatureCheckBox->isChecked();
  flagVariables[17] = totalAccumulationCurvatureCheckBox->isChecked();

  std::string suffix[18];
  suffix[0] = "_Slope";
  suffix[1] = "_GradFactor";
  suffix[2] = "_HorCurv";
  suffix[3] = "_PlanCurv";
  suffix[4] = "_VertCurv";
  suffix[5] = "_MeanCurv";
  suffix[6] = "_LongCurv";
  suffix[7] = "_CrossSecCurv";
  suffix[8] = "_Unsph";
  suffix[9] = "_MinCurv";
  suffix[10] = "_MaxCurv";
  suffix[11] = "_DiffCurv";
  suffix[12] = "_HECurv";
  suffix[13] = "_VECurv";
  suffix[14] = "_Rotor";
  suffix[15] = "_TGaussCurv";
  suffix[16] = "_TRingCurv";
  suffix[17] = "_TAccumCurv";

  bool varflag = false;
  unsigned int i = 0;
  while ((varflag == false) && (i<18))
  {
	  varflag = flagVariables[i];
	  i++;
  }
  if(!varflag)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Please select at least one morphometric variable."));
		return;
  }

  // Parameters
  std::string demGridName = demGridComboBox->currentText().latin1();
  std::string outGridName = gridNameLineEdit->text().latin1();

  // open input raster's
  TeDatabase* database = parameters_->getCurrentDatabasePtr();
  HidroUtils utils( database );

  TeView* view = NULL;
  if(ViewCheckBox->isChecked())
  {
    // Get View
    view = parameters_->getCurrentViewPtr();
    if( !view )
    {
      QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
      return;
    }
  }

  // DEM
  TeLayer* demLayer = NULL;
	demLayer = utils.getLayerByName( demGridName );
  TeRaster* demRaster = NULL;
  demRaster = demLayer->raster();

  // output raster
  TeRaster* rasterpoint[18];
  for( unsigned int i=0; i<18; i++ )
  {
    rasterpoint[i] = NULL;
  }

  // Morphometric Variable
  HidroMorphometricVariables morphometricVariables( demRaster, rasterpoint, flagVariables);

  // execut the algorithm
  if( !morphometricVariables.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(morphometricVariables.getErrorMessage().c_str()));    
    return;
  }

  // import result to database and save theme to current view
  TeProgress::instance()->reset();
  TeProgress::instance()->setMessage("Saving Morphometric Variables into database.");
  std::string layername;
  for( unsigned int i=0; i<18; i++ )
  {
    if( rasterpoint[i] != NULL)
	{
		layername = database->getNewLayerName( outGridName+suffix[i] );
		if( view )
		{
			utils.saveOutputRasterCreatingTheme( layername, rasterpoint[i], view);
//			TeTheme* theme = utils.getThemeByName( layername );
//			theme->visibility(1);
		}
		else
		{
			utils.saveOutputRaster( layername, rasterpoint[i] );
		}
	}
  }

  // update the TerraView interface
  parameters_->updateTVInterface();

  // informe the successful process
  QString message;
  message.append("Morphometric Variables\n");
  message.append("Start Time: ");
  message.append( morphometricVariables.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( morphometricVariables.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( morphometricVariables.getTimeTotal().c_str() );

  QMessageBox::information(this, tr("Information"), tr(message) );  

  // close the window
  accept();

}


bool HidroMorphometricVariablesWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  demGridComboBox->clear();
	demGridComboBox->insertItem("");

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{
		demGridComboBox->insertItem(layerNames[i].c_str());		
  }

  // qsettings defaults
//  QSettings settings;

  // LDD
//  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

//  QString lastDEM = settings.readEntry("lastDEM");
   
//  int index;

//  index = comboboxFind( demGridComboBox, lastDEM );
//  demGridComboBox->setCurrentItem( index );

  return true;
}
