/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroRiversL.h>
#include <HidroRiversLWindow.h>
#include <HidroUtils.h>
#include <HidroFlowUtils.h>
#include <HidroPersister.h>
#include <HidroBatchPointsWindow.h>
#include <qsettings.h>
#include <qcombobox.h>
#include <TeGeometry.h>

bool HidroRiversLWindow::init( PluginParameters *parameters )
{
	if( parameters == NULL )
	{
		return false;
	}
	RLKm->setDisabled( true );
	RLKm_2->setDisabled(false);

	if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

	parameters_ = parameters;

	// clear all layers names inside the combo box
	RLLDDComboBox->clear();
	RLLDDComboBox->insertItem(""); 

	// fill it with raster layers
	HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );

	// clear all layers names inside the combo box
	RLLDrainageComboBox_2->clear();
	RLLDrainageComboBox_2->insertItem(""); 

	RLLContributingComboBox_2_2->clear();
	RLLContributingComboBox_2_2->insertItem(""); 

	WatershedComboBox->clear();
	WatershedComboBox->insertItem(""); 

	DEMGrid_ComboBox->clear();
	DEMGrid_ComboBox->insertItem(""); 

	// fill it with raster layers
	for(unsigned int i = 0; i < layerNames.size(); ++i)
	{
		RLLDrainageComboBox_2->insertItem(layerNames[i].c_str());
		RLLDDComboBox->insertItem(layerNames[i].c_str());
		RLLContributingComboBox_2_2->insertItem(layerNames[i].c_str());
		WatershedComboBox->insertItem(layerNames[i].c_str());
		DEMGrid_ComboBox->insertItem(layerNames[i].c_str());

	}

	BatchComboBox->clear();
	BatchComboBox->insertItem("");

	std::vector<std::string> pointLayerNames = utils.listLayers( false, false, true );
  
	for(unsigned int i = 0; i < pointLayerNames.size(); ++i)
	{
		BatchComboBox->insertItem(pointLayerNames[i].c_str());
	}

	// qsettings defaults
	QSettings settings;

	// LDD
	settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
	  
	int index;  

	QString lastLDD = settings.readEntry("lastLDD");
	QString lastACU = settings.readEntry("lastACU");
	QString lastDRE = settings.readEntry("lastDRE");
	QString lastDEM = settings.readEntry("lastDEM");
	QString lastPoints = settings.readEntry("lastPoints");
	QString lastSUB = settings.readEntry("lastSUB");
	index = comboboxFind( BatchComboBox, lastPoints );
	BatchComboBox->setCurrentItem( index );

	index = comboboxFind( RLLDDComboBox, lastLDD );
	RLLDDComboBox->setCurrentItem( index );

	index = comboboxFind( RLLContributingComboBox_2_2, lastACU );
	RLLContributingComboBox_2_2->setCurrentItem( index );

	index = comboboxFind( RLLDrainageComboBox_2, lastDRE );
	RLLDrainageComboBox_2->setCurrentItem( index );

	index = comboboxFind( WatershedComboBox, lastSUB );
	WatershedComboBox->setCurrentItem( index );

	index = comboboxFind( DEMGrid_ComboBox, lastDEM );
	DEMGrid_ComboBox->setCurrentItem( index );
	return true;
}


void HidroRiversLWindow::RLPushButton_clicked()
{

  TeView* view = 0;
  view = parameters_->getCurrentViewPtr();
  if( !view )
  {
    QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
    return;
  }

  // Input
	if(RLLDDComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input LDD not defined."));
		return;
	}

	if(RLLDrainageComboBox_2->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Drainage not defined."));
		return;
	}

	if(RLLContributingComboBox_2_2->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Contributing area not defined."));
		return;
	}

	if(DEMGrid_ComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM Grid area not defined."));
		return;
	}

	HidroUtils utils(parameters_->getCurrentDatabasePtr());
	std::string errorMessage = "";

	if(RLedNameLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output name not defined."));
		return;
	}

	if(!utils.checkLayerName(RLedNameLineEdit->text().latin1(), errorMessage))
	{
		QMessageBox::warning(this, tr("Warning"), errorMessage.c_str());
		return;
	} 

	// pega ponto do exutorio
	TeLayer* batchPointLayer = NULL;
	batchPointLayer = utils.getLayerByName(BatchComboBox->currentText().latin1());
	if(!batchPointLayer)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Error getting Batch Points layer from database."));
		return;
	}

	TePointSet pointSet;
	if( !batchPointLayer->getPoints( pointSet ) )
	{
		QMessageBox::warning(this, tr("Warning"), tr("The layer dont have any points!"));    
		return;
	}

	TeLayer* lddLayer = NULL;
	lddLayer = utils.getLayerByName( RLLDDComboBox->currentText().latin1() );
	TeRaster* lddRaster = NULL;
	lddRaster = lddLayer->raster();

	string t = lddRaster->params().projection()->name();
	float Res;

	if(RLKm_2->text().isEmpty())
	{
			QMessageBox::warning(this, tr("Warning"), tr("Output resolution not defined."));
			return;
	}

		 // get resoluytion
	RLKm->setDisabled( false );
	Res = RLKm_2->text().toFloat();

	bool gen_prof = Profile->isChecked();

	TeLayer* drLayer = NULL;
	drLayer = utils.getLayerByName( RLLDrainageComboBox_2->currentText().latin1() );
	TeRaster* drRaster = NULL;
	drRaster = drLayer->raster();

	TeLayer* ctLayer = NULL;
	ctLayer = utils.getLayerByName( RLLContributingComboBox_2_2->currentText().latin1() );
	TeRaster* ctRaster = NULL;
	ctRaster = ctLayer->raster();

	TeLayer* DEMLayer = NULL;
	DEMLayer = utils.getLayerByName( DEMGrid_ComboBox->currentText().latin1() );
	TeRaster* DEMRaster = NULL;
	DEMRaster = DEMLayer->raster();

	TeLayer* SUBLayer = NULL;
	SUBLayer = utils.getLayerByName( WatershedComboBox->currentText().latin1() );
	TeRaster* SUBRaster = NULL;
	SUBRaster = SUBLayer->raster();

	// output raster
	TeRaster* RLRaster=NULL;

	 std::string outputName = RLedNameLineEdit->text().latin1();

	HidroRiversLenght riversl(lddRaster,drRaster,ctRaster,RLRaster,Res,gen_prof,pointSet,DEMRaster,SUBRaster,outputName);

	if( !riversl.execute() )
	{
		QMessageBox::warning(this, tr("Warning"), tr(riversl.getErrorMessage().c_str())); 
		if(RLRaster)
		{
			delete RLRaster;
		}
		return;
	}
	
	RLKm->setText( QString::number( riversl.get_RLenght() ) );


	// import result to database
	TeProgress::instance()->setMessage("Saving Accumulated Raster into database.");
	utils.saveOutputRaster( RLedNameLineEdit->text().latin1(), RLRaster );

  // create theme  
	TeLayer* RLLayer = NULL;
	RLLayer = utils.getLayerByName( RLedNameLineEdit->text().latin1() );
	if( view )
	{
		utils.rasterTheme( view, RLLayer );
	}

	// update settings
	QSettings settings;  
	settings.setPath( "TerraHidro.br", "LDD", QSettings::User );
	settings.writeEntry( "lastLDD", RLLDDComboBox->currentText() );
	
	// update the TerraView interface
	parameters_->updateTVInterface();

	// informe the successful process
	QString message;
	message.append("Rivers Lengt\n");
	message.append("Start Time: ");
	message.append( riversl.getTimeStart().c_str() );
	message.append("\nEnd Time: ");
	message.append( riversl.getTimeEnd().c_str() );
	message.append("\n\nTotal Time: ");
	message.append( riversl.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );
}
